<?php
session_start();


if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Location: index.php');
    exit;
}
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    die("Yasaklı istek.");
}

if (!isset($_SESSION['csrf_token']) || !hash_equals($_SESSION['csrf_token'], $_POST['csrf_token'] ?? '')) {
    die("CSRF doğrulaması başarısız.");
}

$title = trim($_POST['title'] ?? '');
$year = (int)($_POST['year'] ?? 0);
$month = (int)($_POST['month'] ?? 0);

if (!$title || mb_strlen($title) > 100) {
    die("Geçersiz alışkanlık adı.");
}

if ($year < 2000 || $year > 2100) {
    die("Geçersiz yıl seçimi.");
}

if ($month < 1 || $month > 12) {
    die("Geçersiz ay seçimi.");
}

require_once 'config.php';

// Giriş kontrolü (istersen kullan)
check_login();

$user_id = $_SESSION['user_id'] ?? null;
if (!$user_id) {
    die("Kullanıcı bilgisi bulunamadı.");
}

// Alışkanlığı kullanıcıya bağlayarak ekle, year ve month ile
$stmt = $pdo->prepare("INSERT INTO habits (user_id, title, year, month, created_at) VALUES (:user_id, :title, :year, :month, NOW())");
$stmt->execute([
    'user_id' => $user_id,
    'title' => $title,
    'year' => $year,
    'month' => $month
]);

header("Location: index.php");
exit;
