<?php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Oturum açılmamışsa yönlendir
if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    header("Location: login.php");
    exit;
}

// Zaman aşımı kontrolü (örnek: 10 dakika)
$oturum_suresi = 10 * 60; // 10 dakika




if (isset($_SESSION['last_activity']) && (time() - $_SESSION['last_activity']) > $oturum_suresi) {
    // Oturum süresi doldu, çıkış yap
    session_unset();
    session_destroy();
    header("Location: login.php?timeout=1");
    exit;
}

// Oturumu güncelle
$_SESSION['last_activity'] = time();
