<?php
session_start();

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Location: index.php');
    exit;
}

if (!isset($_POST['csrf_token']) || !hash_equals($_SESSION['csrf_token'], $_POST['csrf_token'])) {
    http_response_code(403);
    die("CSRF doğrulaması başarısız.");
}

$id = isset($_POST['id']) ? (int)$_POST['id'] : 0;
if ($id <= 0) {
    http_response_code(400);
    die("Geçersiz alışkanlık ID'si.");
}

require_once 'config.php';

// Kullanıcı giriş kontrol fonksiyonunu çağır
check_login();

$user_id = $_SESSION['user_id'] ?? null;
if (!$user_id) {
    http_response_code(403);
    die("Kullanıcı doğrulanamadı.");
}

// Alışkanlığın kullanıcıya ait olup olmadığını kontrol et (güvenlik için)
$stmt = $pdo->prepare("SELECT id FROM habits WHERE id = ? AND user_id = ?");
$stmt->execute([$id, $user_id]);
if ($stmt->rowCount() === 0) {
    http_response_code(404);
    die("Alışkanlık bulunamadı veya yetkiniz yok.");
}

// Transaction açarak işlemleri güvenli yapalım
try {
    $pdo->beginTransaction();

    // Alışkanlık ile ilgili işaretlemeleri sil
    $stmtDeleteMarks = $pdo->prepare("DELETE FROM habit_checkmarks WHERE habit_id = ?");
    $stmtDeleteMarks->execute([$id]);

    // Alışkanlığı sil
    $stmtDeleteHabit = $pdo->prepare("DELETE FROM habits WHERE id = ? AND user_id = ?");
    $stmtDeleteHabit->execute([$id, $user_id]);

    $pdo->commit();

    echo "OK";

} catch (Exception $e) {
    $pdo->rollBack();
    http_response_code(500);
    error_log("Alışkanlık silme hatası: " . $e->getMessage());
    die("Alışkanlık silinirken hata oluştu.");
}
