<?php
require_once 'auth.php';
require_once 'config.php';

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

check_login();


// Motivasyon sözleri dizisi
$motivasyonSozleri = [
    "Başarı, küçük çabaların tekrar tekrar yapılmasıdır.",
    "Bugün yaptıkların yarının temelini oluşturur.",
    "Her alışkanlık bir adım daha ileri demektir.",
    "İlerlemenin sırrı, başlamaktır.",
    "Kendine inan, her şey mümkün!",
    "Her gün yeni bir başlangıçtır.",
    "Disiplin, özgürlüğün anahtarıdır.",
    "Başlamak için mükemmel olmanı bekleme.",
    "Küçük değişiklikler büyük farklar yaratır.",
    "Bugün attığın küçük bir adım, yarın seni hayal ettiğin yere taşıyabilir.",
"Başlamadan bilemezsin, denemeden başaramazsın.",
"Yavaş ilerlesen de, harekette olduğun sürece yol alıyorsun.",
"Vazgeçmek kolaydır; kalmak, çabalamak cesaret ister.",
"Her sabah yeni bir şans, her gece yeni bir ders taşır.",
"Büyük işler, küçük ama istikrarlı çabalarla başarılır.",
"Hayal kurmaktan korkma; her başarı bir hayalle başlar.",
"Engeller, kararlılığın ne kadar güçlü olduğunu sınar.",
"Düşmekten değil, kalkmamaktan kork.",
"Her yeni gün, yeniden başlamak için bir fırsattır.",
"Başarı, tekrar tekrar denemeye cesaret edebilmektir.",
"Yorulduğunda değil, başardığında dur.",
"Başladığın işi bitir; zafer, son adımda gizlidir.",
"Zihnini değiştir, hayatın da değişmeye başlasın.",
"Kendi hikâyeni sen yaz, başkalarının kalemine teslim olma.",
"Küçük hedefler büyük alışkanlıklar doğurur.",
"Bugün gösterdiğin sabır, yarının gücüdür.",
"Kendi ışığını yak; başkalarının onayına ihtiyaç duymadan parılda.",
"Hayat, sen cesur olduğunda değişmeye başlar.",
"Beklemek değil, harekete geçmek hayalleri gerçeğe dönüştürür.",
"Gerçek motivasyon, zorlandığında bile devam etmektir.",
"Kendine inandığın sürece sınır yoktur.",
"Hayat mükemmel olmaz; ama sen gelişebilirsin.",
"Her zorluk seni biraz daha güçlü kılar.",
"Değişim, konfor alanının dışına adım attığında başlar.",
"Her gün biraz daha iyi olmak mümkündür.",
"Bir gün değil, bugün başla.",
"Zaman geçer ama sen yön verebilirsin.",
"Azimle örülmüş yollar başarıya çıkar.",
"Kusurlar seni insan yapar; cesaretin seni özel kılar.",
"Bugün yapmadığın şey, yarın seni bekliyor olmayabilir.",
"Hayat seninle başlar; başkasını bekleme.",
"Gelişim, en küçük kararların toplamıdır.",
"Başarısızlık son değil; yeniden denemen için bir başlangıçtır.",
"Her gün yeniden başlamak, güçlü bir seçimdir.",
"Gerçek değişim içeriden başlar.",
"Hayat, kendini bulduğunda değil; kendini yarattığında anlam kazanır.",
"Yetenek doğuştandır, başarı alışkanlıktır.",
"Kendine verdiğin sözleri tut; bu seni dönüştürür.",
"Korkularınla değil, hedeflerinle konuş.",
"Başarıya giden yol, sabırla döşenmiş adımlardır.",
"İmkânsız sadece henüz yapılmamış olandır.",
"Ne kadar geç olursa olsun, başlamak için doğru zaman şimdi.",
"Kendine karşı dürüst olmak, en büyük gücündür.",
"İnandığın sürece yol bulursun; inanmadığında bahane üretirsin.",
"Gücün sandığından daha büyük, cesaretin yolda büyür.",
"Bir gülümseme bile değişimin kıvılcımı olabilir.",
"Yapabileceğine inandığında, yarı yolu geçmişsindir.",
"Her şey seninle başlar; önce sen inan, sonra dünya ikna olur.",
    "Sürekli olmak, başarıyı getirir."
];

$seciliSoz = $motivasyonSozleri[array_rand($motivasyonSozleri)];



$user_id = $_SESSION['user_id'] ?? null;
if (!$user_id) {
    header("Location: login.php");
    exit;
}

// Filtre değerlerini al (GET ile, yoksa varsayılan olarak bu ay ve yıl)
$filterYear = isset($_GET['year']) && $_GET['year'] !== '' ? (int)$_GET['year'] : (int)date('Y');
$filterMonth = isset($_GET['month']) && $_GET['month'] !== '' ? (int)$_GET['month'] : (int)date('m');

// Eğer yıl ve ay boşsa (tümünü göster seçilirse), bunları null yap
if (isset($_GET['year']) && $_GET['year'] === '') {
    $filterYear = null;
}
if (isset($_GET['month']) && $_GET['month'] === '') {
    $filterMonth = null;
}

// Sorgu koşulu:
if ($filterYear && $filterMonth) {
    $stmt = $pdo->prepare("SELECT * FROM habits WHERE user_id = ? AND year = ? AND month = ? ORDER BY id DESC");
    $stmt->execute([$user_id, $filterYear, $filterMonth]);
} else {
    $stmt = $pdo->prepare("SELECT * FROM habits WHERE user_id = ? ORDER BY year DESC, month DESC, id DESC");
    $stmt->execute([$user_id]);
}

$habits = $stmt->fetchAll(PDO::FETCH_ASSOC);


// Kullanıcının işaretlemelerini al
$habit_ids = array_column($habits, 'id');
$markMap = [];
if ($habit_ids) {
    $placeholders = implode(',', array_fill(0, count($habit_ids), '?'));
    $stmt2 = $pdo->prepare("SELECT habit_id, check_date, checked, note, checked_at FROM habit_checkmarks WHERE habit_id IN ($placeholders)");
    $stmt2->execute($habit_ids);

    foreach ($stmt2 as $m) {
        $markMap[$m['habit_id']][$m['check_date']] = [
            'checked' => $m['checked'],
            'note' => $m['note'],
            'checked_at' => $m['checked_at']
        ];
    }
}

// Ay ve yıl seçenekleri fonksiyonları
function buildMonthOptions($selected = null) {
    $months = [
        1 => 'Ocak', 2 => 'Şubat', 3 => 'Mart', 4 => 'Nisan',
        5 => 'Mayıs', 6 => 'Haziran', 7 => 'Temmuz', 8 => 'Ağustos',
        9 => 'Eylül', 10 => 'Ekim', 11 => 'Kasım', 12 => 'Aralık'
    ];
    $html = '';
    foreach ($months as $num => $name) {
        $sel = ($num == $selected) ? 'selected' : '';
        $html .= "<option value=\"$num\" $sel>$name</option>";
    }
    return $html;
}

function buildYearOptions($selected = null) {
    $currentYear = (int)date('Y');
    $html = '';
    for ($y = $currentYear - 5; $y <= $currentYear + 1; $y++) {
        $sel = ($y == $selected) ? 'selected' : '';
        $html .= "<option value=\"$y\" $sel>$y</option>";
    }
    return $html;
}
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

  <meta charset="UTF-8" />
  <title>Alışkanlık Takibi</title>
<style>
:root {
  --bg: #f0f4f8;
  --white: #ffffff;
  --primary: #4a90e2;
  --text: #333;
  --border: #e0e0e0;
  --hover: #f9fbfc;
}

body {
  font-family: 'Segoe UI', sans-serif;
  margin: 0;
  padding: 40px;
  background-color: var(--bg);
  color: var(--text);
}

h1 {
  text-align: center;
  margin-bottom: 30px;
  font-size: 2em;
  color: var(--primary);
}

form#filter-form {
  display: flex;
  justify-content: center;
  margin-bottom: 25px;
  gap: 10px;
  flex-wrap: wrap;
  align-items: center;
}

form#filter-form select,
form#filter-form button {
  padding: 8px 12px;
  font-size: 1em;
  border-radius: 6px;
  border: 1px solid #ccc;
  cursor: pointer;
}

form#filter-form button {
  background-color: var(--primary);
  color: white;
  border: none;
  font-weight: bold;
  transition: background-color 0.3s ease;
}

form#filter-form button:hover {
  background-color: #357ab8;
}

form[action="add_habit.php"] {
  display: flex;
  justify-content: center;
  align-items: center;
  flex-wrap: wrap;
  gap: 10px;
  margin-bottom: 20px;
}

form[action="add_habit.php"] input[type="text"],
form[action="add_habit.php"] select {
  padding: 10px;
  border: 1px solid var(--border);
  border-radius: 8px;
  font-size: 1em;
}

form[action="add_habit.php"] button {
  padding: 10px 20px;
  border: none;
  background-color: var(--primary);
  color: white;
  font-size: 1em;
  border-radius: 8px;
  cursor: pointer;
}

form[action="add_habit.php"] button:hover {
  background-color: #357ab8;
}

table {
  width: 100%;
  border-collapse: collapse;
  background-color: var(--white);
  box-shadow: 0 0 10px rgba(0, 0, 0, 0.06);
  border-radius: 10px;
  overflow: hidden;
}

th, td {
  border: 1px solid var(--border);
  padding: 8px;
  text-align: center;
  font-size: 0.9em;
  vertical-align: top;
}

th {
  background-color: var(--primary);
  color: white;
  font-weight: normal;
}

tr:nth-child(even) {
  background-color: var(--hover);
}

tr:hover {
  background-color: #e9f2ff;
}

.habit-title {
  text-align: left;
  padding-left: 12px;
  font-weight: bold;
  color: #444;
  width: 220px;
}

input[type="checkbox"] {
  transform: scale(1.4);
  cursor: pointer;
  margin-bottom: 4px;
}

textarea.habit-note {
  display: none;
  margin-top: 5px;
  width: 95%;
  font-size: 0.8em;
  padding: 4px;
  border: 1px solid var(--border);
  border-radius: 5px;
  resize: vertical;
}

.checked-time {
  font-size: 0.75em;
  color: gray;
  margin-top: 4px;
}

td.checked-cell {
  background-color: #d4edda !important;
}

.delete-btn {
  float: right;
  color: red;
  cursor: pointer;
  font-size: 1em;
  background: none;
  border: none;
}

@media screen and (max-width: 768px) {
  body {
    padding: 15px;
  }

  table, thead, tbody, th, td, tr {
    display: block;
  }

  thead {
    display: none;
  }

  tr {
    margin-bottom: 20px;
    background: var(--white);
    border-radius: 10px;
    padding: 10px;
    box-shadow: 0 0 5px rgba(0,0,0,0.05);
  }

  td {
    display: flex;
    flex-direction: column;
    align-items: flex-start;
    padding: 8px 12px;
  }

  .habit-title {
    width: auto;
    font-size: 1em;
  }

  .delete-btn {
    float: none;
    align-self: flex-end;
    margin-top: 6px;
  }

  form#filter-form,
  form[action="add_habit.php"] {
    flex-direction: column;
    align-items: stretch;
  }

  form#filter-form select,
  form#filter-form button,
  form[action="add_habit.php"] input[type="text"],
  form[action="add_habit.php"] select,
  form[action="add_habit.php"] button {
    width: 100%;
    padding: 14px 12px;
    font-size: 1em;
    border-radius: 8px;
  }

  textarea.habit-note {
    width: 100% !important;
  }

  .day-number {
    font-weight: bold;
    margin-bottom: 6px;
    color: #4a90e2;
  }
}

.day-number {
  display: none; /* Varsayılan olarak gizli (masaüstü için) */
}

@media screen and (max-width: 768px) {
  .day-number {
    display: block; /* Sadece mobilde görünür */
    font-weight: bold;
    margin-bottom: 6px;
    color: #4a90e2;
  }
}

@media screen and (max-width: 768px) {
  td {
    display: flex;
    flex-direction: column;
    align-items: flex-start;
    padding: 6px 10px;
    border: 1px solid var(--border);
  }

  input[type="checkbox"] {
    transform: scale(1.2); /* Daha küçük gösterim */
    margin: 2px 0;
  }

  .habit-note {
    font-size: 0.75em;
    padding: 4px;
    margin-top: 4px;
  }

  .checked-time {
    font-size: 0.7em;
  }
}

@media screen and (max-width: 768px) {
  .habit-table-container {
    display: none !important;
  }
  .habit-accordion-container {
    display: block !important;
  }
}
@media screen and (min-width: 769px) {
  .habit-table-container {
    display: block !important;
  }
  .habit-accordion-container {
    display: none !important;
  }
}

</style>

</head>
<body>

<h1>Alışkanlık Takibi</h1>

 <?php if (isset($_SESSION['username'])): ?>
    <div style="color:#555; display: flex; justify-content: center; align-items: center; gap: 10px; margin-bottom: 20px; flex-wrap: wrap">
      👋 Merhaba, <strong><?= htmlspecialchars(trim(($_SESSION['ad'] ?? '') . ' ' . ($_SESSION['soyad'] ?? ''))) ?></strong>
    </div>
  <?php endif; ?>

<br>
<p style="font-style: italic; color: #555; margin-top: -10px; margin-bottom: 20px; text-align: center; font-weight: bold;">
  <?= htmlspecialchars($seciliSoz, ENT_QUOTES, 'UTF-8') ?>
</p>






<div style="display: flex; justify-content: flex-end; align-items: center; gap: 10px; margin-bottom: 20px; flex-wrap: wrap;">
 



  <button onclick="window.location.href='ayarlar.php'" class="btn btn-secondary" style="padding: 8px 12px; border-radius: 6px;">⚙️ Ayarlar</button>
  <button onclick="window.location.href='istatistik.php'" class="btn btn-info" style="padding: 8px 12px; border-radius: 6px;">📊 İstatistik</button>

  <form action="logout.php" method="POST" style="display: flex; align-items: center;">
  <button type="submit" style="
    background-color: #dc3545;
    color: white;
    border: none;
    padding: 8px 12px;
    border-radius: 6px;
    cursor: pointer;
    margin:0px !important;
  ">Çıkış Yap</button>
</form>

</div>





<!-- Filtreleme formu -->
<form id="filter-form" method="GET" action="">
  <label for="filter_year">Yıl:</label>
  <select name="year" id="filter_year">
    <option value="" <?= ($filterYear === null) ? 'selected' : '' ?>>Tümü</option>
    <?= buildYearOptions($filterYear) ?>
  </select>

  <label for="filter_month">Ay:</label>
  <select name="month" id="filter_month">
    <option value="" <?= ($filterMonth === null) ? 'selected' : '' ?>>Tümü</option>
    <?= buildMonthOptions($filterMonth) ?>
  </select>

  <button type="submit">Filtrele</button>
<button type="button" onclick="window.location.href='index.php?year=&month='">Tümünü Göster</button>

<button type="button" onclick="window.location.href='index.php'">Günceli Göster</button>


</form>



<!-- (Sonraki form: yeni alışkanlık ekleme formu) -->
<form action="add_habit.php" method="POST" style="margin-bottom: 20px;">
  <input type="hidden" name="csrf_token" value="<?= $_SESSION['csrf_token'] ?>">
  <input type="text" name="title" placeholder="Yeni alışkanlık ekle..." required style="width: 300px; padding: 8px;">
  
  <select name="year" required>
    <?= buildYearOptions($filterYear) ?>
  </select>
  
  <select name="month" required>
    <?= buildMonthOptions($filterMonth) ?>
  </select>
  
  <button type="submit">Ekle</button>
</form>
<div class="habit-table-container">

<table>
  <thead>
    <tr>
      <th>Alışkanlık</th>
      <th>Yıl</th>
      <th>Ay</th>
      <?php for ($d = 1; $d <= 31; $d++): ?>
        <th><?= str_pad($d, 2, '0', STR_PAD_LEFT) ?></th>
      <?php endfor; ?>
    </tr>
  </thead>
  <tbody>
    <?php foreach ($habits as $habit): ?>
      <tr data-habit-id="<?= (int)$habit['id'] ?>">
        <td class="habit-title"><?= htmlspecialchars($habit['title']) ?>
          <button class="delete-btn" data-id="<?= $habit['id'] ?>" style="float: right; color: red; cursor: pointer;" title="Sil">🗑️</button>
        </td>
        <td><?= (int)$habit['year'] ?></td>
        <td><?= ['','Ocak','Şubat','Mart','Nisan','Mayıs','Haziran','Temmuz','Ağustos','Eylül','Ekim','Kasım','Aralık'][(int)$habit['month']] ?></td>

        <?php for ($d = 1; $d <= 31; $d++):
          $date = sprintf('%04d-%02d-%02d', (int)$habit['year'], (int)$habit['month'], $d);
          $data = $markMap[$habit['id']][$date] ?? [];
          $checked = $data['checked'] ?? false;
          $note = htmlspecialchars($data['note'] ?? '', ENT_QUOTES, 'UTF-8');
          $checked_at = $data['checked_at'] ?? '';
        ?>
        <td class="<?= $checked ? 'checked-cell' : '' ?>">
              <div class="day-number"><?= $d ?>. gün</div> <!-- ← BURASI YENİ -->

          <input type="checkbox"
                 data-habit-id="<?= $habit['id'] ?>"
                 data-date="<?= $date ?>"
                 <?= $checked ? 'checked' : '' ?>>

          <textarea class="habit-note"
                    data-habit-id="<?= $habit['id'] ?>"
                    data-date="<?= $date ?>"
                    placeholder="Not ekle..."
                    style="display: <?= $checked ? 'block' : 'none' ?>;"><?= $note ?></textarea>

          <?php if ($checked_at): ?>
            <div class="checked-time"><?= date('d.m.Y H:i', strtotime($checked_at)) ?> işaretlendi</div>
          <?php endif; ?>
        </td>
        <?php endfor; ?>
      </tr>
    <?php endforeach; ?>
  </tbody>
</table>
</div>


<div class="habit-accordion-container" style="display:none;">
  <?php foreach ($habits as $habit): ?>
    <div class="habit-accordion-item">
      <div class="habit-header" data-habit-id="<?= (int)$habit['id'] ?>" style="cursor:pointer; font-weight:bold; padding:10px; border:1px solid #ccc; margin-bottom: 4px;">
        <?= htmlspecialchars($habit['title']) ?>
        <button class="delete-btn" data-id="<?= $habit['id'] ?>" style="float:right; color:red;">🗑️</button>
      </div>
      <div class="habit-details" id="habit-details-<?= (int)$habit['id'] ?>" style="display:none; padding:10px; border:1px solid #ccc; border-top:none; margin-bottom: 15px;">
        <div><strong>Yıl:</strong> <?= (int)$habit['year'] ?> &nbsp;&nbsp; <strong>Ay:</strong> <?= ['','Ocak','Şubat','Mart','Nisan','Mayıs','Haziran','Temmuz','Ağustos','Eylül','Ekim','Kasım','Aralık'][(int)$habit['month']] ?></div>
        <div style="display:flex; flex-wrap: wrap; gap: 6px; margin-top: 8px;">
          <?php
            $maxDay = cal_days_in_month(CAL_GREGORIAN, (int)$habit['month'], (int)$habit['year']);
            for ($d = 1; $d <= $maxDay; $d++):
              $date = sprintf('%04d-%02d-%02d', (int)$habit['year'], (int)$habit['month'], $d);
              $data = $markMap[$habit['id']][$date] ?? [];
              $checked = $data['checked'] ?? false;
              $note = htmlspecialchars($data['note'] ?? '', ENT_QUOTES, 'UTF-8');
          ?>
          <div style="border:1px solid #ccc; padding:6px; border-radius:5px; min-width: 60px;">
            <label><?= $d ?>. gün <input type="checkbox"
              data-habit-id="<?= $habit['id'] ?>"
              data-date="<?= $date ?>"
              <?= $checked ? 'checked' : '' ?>></label>
            <textarea class="habit-note"
              data-habit-id="<?= $habit['id'] ?>"
              data-date="<?= $date ?>"
              placeholder="Not ekle..."
              style="display: <?= $checked ? 'block' : 'none' ?>; width: 100%;"></textarea>
          </div>
          <?php endfor; ?>
        </div>
      </div>
    </div>
  <?php endforeach; ?>
</div>




<script>
const csrfToken = <?= json_encode($_SESSION['csrf_token']) ?>;

// Checkbox işaretleme
document.querySelectorAll('input[type="checkbox"]').forEach(cb => {
  cb.addEventListener('change', function () {
    const habitId = this.dataset.habitId;
    const date = this.dataset.date; // yyyy-mm-dd
    const checked = this.checked ? 1 : 0;

    // Geçersiz tarih kontrolü
    const parts = date.split("-");
    const yil = parseInt(parts[0]);
    const ay = parseInt(parts[1]);
    const gun = parseInt(parts[2]);
    const ayinSonGunu = new Date(yil, ay, 0).getDate();

    if (gun > ayinSonGunu) {
      alert(`Uyarı: ${yil}-${ay} ayında ${gun}. gün bulunmamaktadır. Bu ay ${ayinSonGunu} gündür.`);
      this.checked = false;
      return; // İşlemi durdur
    }

    const textarea = this.parentElement.querySelector('.habit-note');
    if (textarea) {
      textarea.style.display = checked ? 'block' : 'none';
    }

    fetch('update_checkmark.php', {
      method: 'POST',
      headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
      body: `habit_id=${habitId}&check_date=${encodeURIComponent(date)}&checked=${checked}&csrf_token=${csrfToken}`
    }).then(r => r.text()).then(res => {
      console.log(res);
      if (checked) location.reload(); // Zamanı göstermek için reload (isteğe bağlı)
    });
  });
});

// Not yazıldığında kaydet
document.querySelectorAll('.habit-note').forEach(noteArea => {
  noteArea.addEventListener('change', function () {
    const habitId = this.dataset.habitId;
    const date = this.dataset.date;
    const note = encodeURIComponent(this.value);

    fetch('update_checkmark.php', {
      method: 'POST',
      headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
      body: `habit_id=${habitId}&check_date=${date}&note=${note}&csrf_token=${csrfToken}`
    }).then(r => r.text()).then(console.log);
  });
});

// Alışkanlık silme
document.querySelectorAll('.delete-btn').forEach(btn => {
  btn.addEventListener('click', function () {
    if (!confirm('Bu alışkanlık silinsin mi?')) return;
    const id = this.dataset.id;

    fetch('delete_habit.php', {
      method: 'POST',
      headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
      body: `id=${id}&csrf_token=${csrfToken}`
    }).then(r => r.text()).then(res => {
      if (res === 'OK') location.reload();
      else alert('Silinemedi.');
    });
  });
});



document.querySelectorAll('.habit-header').forEach(header => {
  header.addEventListener('click', () => {
    const id = header.dataset.habitId;
    const details = document.getElementById('habit-details-' + id);
    if (details.style.display === 'none' || details.style.display === '') {
      details.style.display = 'block';
    } else {
      details.style.display = 'none';
    }
  });
});

</script>


</body>


</html>

