<?php
require_once 'config.php';



if (isset($_SESSION['logged_in']) && $_SESSION['logged_in'] === true) {
    header("Location: index.php");
    exit;
}

$hata = '';
$basari = '';

// CAPTCHA sadece sayfa ilk açıldığında (GET isteğinde) üretilsin
if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $captcha1 = rand(1, 10);
    $captcha2 = rand(1, 10);
    $_SESSION['captcha_result'] = $captcha1 + $captcha2;
}

// Form gönderilirse POST bloğu devreye girer
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username'] ?? '');
    $ad = trim($_POST['ad'] ?? '');
    $soyad = trim($_POST['soyad'] ?? '');
    $sifre1 = $_POST['password'] ?? '';
    $sifre2 = $_POST['password2'] ?? '';
    $captcha_input = trim($_POST['captcha'] ?? '');

    if (!$username || !$ad || !$soyad || !$sifre1 || !$sifre2 || !$captcha_input) {
        $hata = "Lütfen tüm alanları doldurun.";
    } elseif ($sifre1 !== $sifre2) {
        $hata = "Şifreler uyuşmuyor.";
    } elseif (strlen($sifre1) < 6) {
        $hata = "Şifre en az 6 karakter olmalı.";
    } elseif ((int)$captcha_input !== ($_SESSION['captcha_result'] ?? -1)) {
        $hata = "Güvenlik sorusunu yanlış yanıtladınız.";
    } else {
        // Kullanıcı adı kontrolü ve kayıt
        $stmt = $pdo->prepare("SELECT id FROM users WHERE username = ?");
        $stmt->execute([$username]);

        if ($stmt->fetch()) {
            $hata = "Bu kullanıcı adı zaten kullanılıyor.";
        } else {
            $hash = password_hash($sifre1, PASSWORD_DEFAULT);
            $ekle = $pdo->prepare("INSERT INTO users (username, ad, soyad, password_hash) VALUES (?, ?, ?, ?)");
            $ekle->execute([$username, $ad, $soyad, $hash]);
            $basari = "Kayıt başarılı! Giriş sayfasına yönlendiriliyorsunuz...";
echo "<meta http-equiv='refresh' content='3;url=login.php'>";

        }
    }
}


?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

  <meta charset="UTF-8">
  <title>Kayıt Ol</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body { background: #f1f4f8; font-family: 'Segoe UI', sans-serif; }
    .register-box {
      max-width: 500px; margin: 50px auto; background: white;
      padding: 30px; border-radius: 10px; box-shadow: 0 0 15px rgba(0,0,0,0.08);
    }
  </style>
</head>
<body>
<div class="register-box">
  <h3 class="text-center text-primary mb-4">Kayıt Ol</h3>

  <?php if ($hata): ?>
    <div class="alert alert-danger"><?= htmlspecialchars($hata) ?></div>
  <?php elseif ($basari): ?>
    <div class="alert alert-success"><?= htmlspecialchars($basari) ?></div>
  <?php endif; ?>

  <form method="POST">
    <div class="mb-3">
      <label class="form-label">Kullanıcı Adı</label>
      <input type="text" name="username" class="form-control" required>
      <div class="form-text text-muted">⚠ Bu bilgi sonradan değiştirilemez.</div>
    </div>

    <div class="mb-3">
      <label class="form-label">Ad</label>
      <input type="text" name="ad" class="form-control" required>
    </div>

    <div class="mb-3">
      <label class="form-label">Soyad</label>
      <input type="text" name="soyad" class="form-control" required>
    </div>

    <div class="mb-3">
      <label class="form-label">Şifre</label>
      <input type="password" name="password" class="form-control" required>
    </div>

    <div class="mb-3">
      <label class="form-label">Şifre (Tekrar)</label>
      <input type="password" name="password2" class="form-control" required>
    </div>



<?php
$captcha1 = $_SESSION['captcha_result'] - rand(0, $_SESSION['captcha_result']);
$captcha2 = $_SESSION['captcha_result'] - $captcha1;
?>

<div class="mb-3">
  <label class="form-label">Güvenlik Sorusu: <?= $captcha1 . " + " . $captcha2 ?> = ?</label>
  <input type="number" name="captcha" class="form-control" required>
    <div class="form-text text-muted">Lütfen sonucu girin</div>
</div>


    <button type="submit" class="btn btn-success w-100">Kayıt Ol</button>
    <div class="mt-3 text-center">
      <a href="login.php" class="text-decoration-none">Zaten üye misiniz? Giriş yap</a>
    </div>
  </form>
</div>

</body>
</html>
